define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/appointments/booked/booked-appointment.html',
    'text!modules/page/content/_primary-header.html',
    'text!modules/appointments/booked/_booked-appointment-details.html',
    'modules/appointments/booked/cancel-by-contacting-facility-view',
    'modules/appointments/booked/booked-appointment-status-view',
    'modules/appointments/booked/appointment-cancel-reason-section-view',
    'modules/appointments/booked/booked-ccappointment-instructions-view',
    'modules/appointments/booked/cancellation-confirm-popup-view',
    'User',
    'App',
    'modules/form/form-view-mixin',
    'modules/appointments/appointments-module',
    'text!modules/calendar/add-to-calendar.html',
],
function (
    _,
    Backbone,
    Marionette,
    template,
    _primaryHeaderTemplate,
    _detailsTemplate,
    CancelByContactingFacilityView,
    StatusView,
    AppointmentCancelReasonSectionView,
    BookedCCInstructionsView,
    CancelConfirmationModal,
    User,
    app,
    Mixin,
    module,
    calendarTemplate
) {
    'use strict';

    return Marionette.View.extend(Mixin.form({
        className: 'appointments',
        template: _.template(template),
        regions: {
            statusRegion: '#appointment-status-group',
            instructionsRegion: '.cc-provider-instructions-section',
        },
        events: {
            'click #back-btn': 'routeToAppointments',
            'click #add-to-calendar-btn': 'loadCalendar',
            'click #cancel-booked-appointment-btn': 'cancelAppointment',
        },
        modelEvents: {
            'remove': 'render',
        },
        initialize: function(options) {
            this._isShowingStatus = false;

            if (!_.isUndefined(options)) {
                if (!_.isUndefined(options.showStatus)) {
                    this._isShowingStatus = options.showStatus;
                }
            }
            if (!_.isUndefined(options.showFeedbackLink)) {
                this._showFeedbackLink = options.showFeedbackLink;
            }
        },
        onAttach: function() {
            if (typeof gas !== 'undefined') {
                gas('send', 'pageview', 'appointment-details');
            }

            if (this._isShowingStatus) {
                this.showStatusView();
            }

            if (this._showFeedbackLink) {
                this.showFeedbackLink();
            }

            if (this.model.has('distanceEligibleConfirmed')) {
                this.showCCInstructions();
            }

            $('.primary-header h2').focus();
        },
        onDestroy: function() {
            this.model.off(null, null, this);
        },
        routeToAppointments: function() {
            Backbone.history.navigate('appointments', {trigger: true});
        },
        showStatusView: function() {
            var statusView;
            var statusRegion;
            if (!this.isDestroyed()) {
                statusRegion = this.getRegion('statusRegion');
                statusView = new StatusView({
                    className: 'modal-content-section',
                    model: this.model,
                });

                statusRegion.show(statusView);
            }
        },
        showFeedbackLink: function () {
            this.$el.find('#appointment-feedback-link').removeClass('hidden');
        },
        showCCInstructions: function() {
            var instructionsRegion = this.getRegion('instructionsRegion');
            if (this.model.get('instructionsToVeteran') !== '') {
                instructionsRegion.show(new BookedCCInstructionsView({
                    model: this.model,
                }));
            }
        },
        fetchCancelReasons: function() {
            return module.fetchCancelReasons({
                siteCode: this.model.get('siteCode'),
                url: app.resources.get('cancel-reasons-list').formatHref({
                    'site-code': this.model.get('siteCode'),
                    'assigning-authority': User.get('idType'),
                    'patient-id': User.get('id'),
                }),
            });
        },
        templateContext: function() {
            return {
                isCancelled: function() {
                    return this.model.isCancelled();
                }.bind(this),
                primaryHeader: _.template(_primaryHeaderTemplate),
                details: _.template(_detailsTemplate),
            };
        },
        getCalendar: function() {
            var appointmentJson = this.model.toJSON();
            var address = this.model.get('address');
            var formattedAddress;
            if (address) {
                formattedAddress = _.escape(address.street || '') + ' \\n'
                    + _.escape(address.city || '') + ' '
                    + _.escape(address.state || '') + ' '
                    + _.escape(address.zipCode || '');
            }
            return _.template(calendarTemplate)({appointment: appointmentJson, address: formattedAddress});
        },
        loadCalendar: function() {
            var str = this.getCalendar();
            var fileName = 'file.ics';
            var blobObject = new Blob([str]);
            var url = 'data:text/calendar;charset=utf-8,' + encodeURIComponent(str);
            if (window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveOrOpenBlob(blobObject, fileName);
            } else {
                window.open(url);
            }
        },
        cancelAppointment: function() {
            var self = this;
            this.fetchCancelReasons().done(function() {
                var popup = new CancelConfirmationModal({
                    model: self.model,
                    validator: self.validator,
                    cancelReasonList: module.cancelReasons(self.model.get('siteCode')),
                    modelType: 'appointment',
                    elAfterClose: '#cancel-booked-appointment-btn',
                });
                popup.openPopup();
            });
        },
        navigateHome: function() {
            this.disableShowConfirmNavigation();
            this.routeHome();
        },
        routeHome: function() {
            window.location.hash = '#appointment';
        },
    }));
});
